definition module EdTextWindow;

import StdClass;
import EdPath, EdTypes, EdProgramState, EdLists;

//	Aux. operations for changing text in edit windows.

// InsertText :: !Bool !EditWindow !Int !Int !Clipboard -> (!EditWindow, !WindowUpdate);
InsertText select wd linenr charnr clip
	:== ReplaceText select wd {l1=linenr,c1=charnr,l2=linenr,c2=charnr} clip;
	
// RemoveText :: !EditWindow !PartTSel -> (!EditWindow, !WindowUpdate);
RemoveText wd tsel
	:== ReplaceText False wd tsel Nil;
	
/* sets current line and char pos in current line.												*/
// SetCurLine :: !EditWindow !Int !Int -> (!EditWindow, !WindowUpdate);
SetCurLine wd lnr cnr
	:== DoSelectText wd lnr cnr lnr cnr;

/* Selects line indicated by 2nd arg.															*/
// SelectLine :: !EditWindow !Int -> (!EditWindow, !WindowUpdate);
SelectLine wd lnr
	:== DoSelectText wd lnr 0 (inc lnr) 0;

/* Selects the entire text																		*/
SelectAllText :: !EditWindow -> (!EditWindow, !WindowUpdate);

/* Adds the clipboard window																	*/
// AddClipboardWindow :: !EditOptions !NrLines !Text !EditWindows !EditWdIds
//						-> (!EditWindows !EditWdIds,!EditWindow,!EditWdId,!Int,!EditWdId);
AddClipboardWindow eoptions nrlines text editwindows editwdids
	:== AddTextWindow ClpbrdWd eoptions DefaultCompilerOptions EmptyTSel nrlines text
			EmptyPathname EmptyPathname editwindows editwdids;
			
/* Adds the project window																		*/
// AddProjectWindow	::	EditOptions !NrLines !Text !Pathname !EditWindows !EditWdIds
//						-> (!EditWindows, !EditWdIds,!EditWindow,!EditWdId,!Int,!EditWdId);
AddProjectWindow eoptions nrlines text path editwindows editwdids
	:== AddTextWindow ProjectWd eoptions DefaultCompilerOptions EmptyTSel nrlines text path
			(RemovePath path) editwindows editwdids;
			
/* Adds a new info window																		*/
// AddInfoWindow ::	!WdType !EditOptions !NrLines !Text !Editor
//					-> (!EditWindows, !EditWdIds,!EditWindow,!EditWdId,!Int,!EditWdId);
AddInfoWindow wdtype eoptions nrlines text editwindows editwdids
	:== AddTextWindow wdtype eoptions DefaultCompilerOptions EmptyTSel nrlines text EmptyPathname
			(if (wdtype == ErrorWd) ErrorPathname TypePathname) editwindows editwdids;
			
/* Adds a new edit window																		*/
// AddEditWindow ::	!EditOptions !CompilerOptions !PartTSel !NrLines !Text !Path !Editor
//					-> (!EditWindows, !EditWdIds,!EditWindow,!EditWdId,!Int,!EditWdId);
AddEditWindow eoptions coptions tsel nrlines text path editwindows editwdids
	:== AddTextWindow EditWd eoptions coptions tsel nrlines text path (RemovePath path)
			editwindows editwdids;
	
/* Adds a new text window																		*/		
AddTextWindow ::	!WdType !EditOptions !CompilerOptions !PartTSel !NrLines !Text !Pathname !Pathname
					!EditWindows !EditWdIds
					-> (!EditWindows,!EditWdIds,!EditWindow,!EditWdId,!Int,!EditWdId);

/* Selects the indicated piece of text (or sets the current line and char number if the			*/
/* selection is empty (only to be used by the macros defined above).							*/
DoSelectText :: !EditWindow !Int !Int !Int !Int -> (!EditWindow, !WindowUpdate); 

/* inserts a new line at the current cursor position. The 1st arg indicates whether the new		*/
/* line must be autoindented.																	*/
InsertLine :: !Bool !EditWindow -> (!EditWindow, !LineUpdate);

/* Inserts a new character in the current line.													*/
InsertChar :: !Char !EditWindow -> (!EditWindow, !LineUpdate);

/* Removes characters from the current line. The 1st arg. indicates whether one word/one char	*/
/* must be removed, the 2nd arg. indicates whether the text before/after the cursor must be		*/
/* removed.																						*/
RemoveChars ::	!KeyMode !Bool !EditWindow -> (!EditWindow, !Bool, !Bool, !String, !LineUpdate);

/* Set new cursor position according to key (4th arg.) and modifier (3rd arg.). 2nd arg.		*/
/* indicates whether selection must be extended to new cursor position or not.					*/
/* The 1st arg. is the visable portion of the window.											*/
DirectionKey ::	!PictureDomain !Bool !KeyMode !Char !EditWindow -> (!EditWindow, !WindowUpdate);

/* copies text selected by 2nd arg.																*/
CopyText :: !EditWindow !PartTSel -> (!EditWindow, !Clipboard);

/* replaces text selected by 3rd arg. by text in 4th arg., if 1st arg. is true the new text is	*/
/* selected.																					*/
ReplaceText :: !Bool !EditWindow !PartTSel !Clipboard -> (!EditWindow, !WindowUpdate);

/* Appends the text contained in the 2nd arg. 													*/
AppendText :: !EditWindow !Text -> (!EditWindow, !WindowUpdate);

/* Selects text as indicated by 2nd arg. If the selection is empty, the cursor is set	to		*/
/* the position of the selection.																*/
SelectText :: !EditWindow !PartTSel -> (!EditWindow, !WindowUpdate);

/* Sets cursor position to start/end of the current selection depending on 1st arg.				*/
SetActiveCursorPos :: !Bool !EditWindow -> EditWindow;

/* Unselects text. if 1st arg. is True the new cursor position is set to the start of the (old)	*/
/* selection, otherwise it is set to the end of the (old) selection.							*/
UnselectText :: !Bool !EditWindow -> (!EditWindow, !WindowUpdate);

/* Sets new text in the window																	*/
SetText :: !NrLines !Text !EditWindow -> EditWindow;

/* Gets text of window																			*/
GetText :: !EditWindow -> (!EditWindow, !NrLines, !Text);

/* Sets new tabwidth, new ront type and new font size in the window								*/
SetTab_and_Font_and_Size :: !Int !FontName !FontSize !EditWindow -> EditWindow;

::	TextReplaceFunction	:==  PartTSel -> FindInfo -> NrLines -> Text -> (!Bool,!ReplacedAll,!PartTSel,!Text);

/* Performs a Find, Replace or Replace&Find operation depending on the 1st arg.					*/
/* The text to be found and replaced is contained in the 2nd arg.								*/
/* the 1st boolean in the result indicates whether the search was successfull, the 2nd one		*/
/* indicates whether the replacement was successfull.											*/
FindReplaceInText :: !EditWindow !FindInfo !TextReplaceFunction -> (!EditWindow,!Bool,!Bool,!PartTSel,!WindowUpdate);

::	TextReplaceAllFunction	:==  Text -> (!Bool,!ReplacedAll,!PartTSel,!Text);

/* Applies the replace function (2nd arg.) to the text.											*/
/* The boolean in the result indicates successfull replacement, the replaced field in the result*/
/* contains undoinfo to undo the replacement													*/
ReplaceAllInText ::	!EditWindow !TextReplaceAllFunction
					-> (!EditWindow,!Bool,!ReplacedAll,!WindowUpdate);

/* Sets current line to the current mouse position. If 1st arg. is True the text between the	*/
/* old cursor position and the current one is selected.											*/
GotoMousePosition :: !Bool !Int !Int !EditWindow -> (!EditWindow, !WindowUpdate);
